//AJAX CALLS WITH FETCH AND PROMISE ASYNC/AWAIT


//ES6 CONSUME THE PROMISE WITH THEN AND CATCH
fetch('https://jsonplaceholder.typicode.com/users')
.then(result =>{
   // console.log(result);
    //the json will return a promise
    return result.json();
})
.then(data =>{
    // console.log(data);
    const user = data[1];
   // console.log(user);
    const name = user.name;
    const userName = user.username;
    const email = user.email;
    const street = user.address.street;
    const city = user.address.city;
    const work = user.company.name;
    console.log(`${name}, ${userName}, ${email},
    ${street}, ${city}, ${work}`);
})
.catch(error =>console.log(error));

//ES8 CONSUME PROMISE ASYNC/AWAIT
async function getUser(){
    try{
        const result = await fetch('https://jsonplaceholder.typicode.com/users');
        const data = await result.json();
        const user = data[9];
        // console.log(user);
         const name = user.name;
         const userName = user.username;
         const email = user.email;
         const street = user.address.street;
         const city = user.address.city;
         const work = user.company.name;
         console.log(`${name}, ${userName}, ${email},
         ${street}, ${city}, ${work}`);
         return data;//always async returns a promise
    }
    catch(error){
        console.log(error);
    }
}

//CALL THE ASYNC FN
getUser().then(data =>{
    console.log(data[2].username);
});